<?php
/*
	Stempora Web Framework
	Copyright (c) 2002-2018 Stempora. 
	All rights reserved.
		web:  www.stempora.com
		mail: support@stempora.com		
*/

// dependencies

/**
* description
*
* @library	
* @author	
* @since	
*/
class CJobs extends CPlugin{
	
	var $tplvars; 

	function __construct() {
		//$this->CPlugin($db, $tables , $templates);

		$this->name == "jobs";
	}

	function DoEvents(){
		global $base, $_CONF, $_TSM , $_VARS , $_USER , $_BASE , $_SESS;

		if ($_GET["mod"] == $this->name) {
			//read the module
			$this->tpl_module = $this->module->plugins["modules"]->getModuleInfo($_GET["module_id"]);
			$this->plugins["modules"]->ValidateModule($this->tpl_module);

			parent::DoEvents();

			$sub = $_GET["sub"];
			$action = $_GET["action"];


			switch ($sub) {

				case "texts":
					return $this->__adminTexts();
				break;
			

				case "landing":
					$sub = "resumes";
				case "resumes":
					$this->plugins["dashboard"]->UpdateModuleAction($this->tpl_module["mod_id"]);

				case "items":					
				case "cats":					
				case "fields":


					if (($sub == "resumes")  && ($_GET["item_id"])){
						$this->db->QueryUpdate(
							$this->tables["plugin:jobs_resumes"],
							array(
								"item_new"	=> "0",
							),
							"item_id={$_GET[item_id]}"
						);
					}
					

					$data = new CSQLAdmin($sub, $this->__parent_templates,$this->db,$this->tables,$extra);
					$data->setAclMod($this->tpl_module);

					if ($sub == "resumes") {
						$this->PrepareMSGFields($data->forms["forms"] , $sub);

						$data->functions = array( 
								"onstore_prepare"		=> array(&$this , "SendMail"),
						);					

					}
					
					$this->PrepareFields($data->forms["forms"]);
					return $data->DoEvents();
				break;

				case "download":
					return $this->DownloadResume();
				break;

				case "messages-delete":
					return $this->MessagesDelete();
				break;

			}
		}
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DownloadResume() {
		$item = $this->db->QFetchArray("SELECT * FROM {$this->tables['plugin:jobs_resumes']} WHERE item_id={$_GET[item_id]}");

		if (is_Array($item)) {

			$mime = new Cmime();
			$mime->Set("unknown");
			$mime->Filename($item["item_file_file"]);

			readfile("../upload/jobs/files/{$item[item_id]}.file");
			die();
		}
		
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function onCreate($module_data) {
		global $_LANG_ID;

		$fields = array(

			array(
				"module_id"		=> $module_data["mod_id"],
				"lang_id"		=> $_LANG_ID,
				"item_field"	=> "first_name",
				"item_type"		=> "usertext",
				"item_required"	=> "1",
				"item_size"		=> "6",
				"item_size_xs"	=> "12",
				"item_title"	=> "First Name",
				"item_error_msg"=> "Enter your first name!",
			),

			array(
				"module_id"		=> $module_data["mod_id"],
				"lang_id"		=> $_LANG_ID,
				"item_field"	=> "last_name",
				"item_type"		=> "usertext",
				"item_required"	=> "1",
				"item_size"		=> "6",
				"item_size_xs"	=> "12",
				"item_title"	=> "Last Name",
				"item_error_msg"=> "Enter your last name!",
			),

			array(
				"module_id"		=> $module_data["mod_id"],
				"lang_id"		=> $_LANG_ID,
				"item_field"	=> "email",
				"item_type"		=> "useremail",
				"item_required"	=> "1",
				"item_size_xs"	=> "12",
				"item_system"	=> "1",
				"item_title"	=> "Email",
				"item_error_msg"=> "Enter your email!",
			),

			array(
				"module_id"		=> $module_data["mod_id"],
				"lang_id"		=> $_LANG_ID,
				"item_field"	=> "phone",
				"item_type"		=> "usertext",
				"item_required"	=> "0",
				"item_size_xs"	=> "12",
				"item_system"	=> "0",
				"item_title"	=> "Phone",
			),

			array(
				"module_id"		=> $module_data["mod_id"],
				"lang_id"		=> $_LANG_ID,
				"item_field"	=> "job",
				"item_type"		=> "userjobs",
				"item_required"	=> "1",
				"item_size_xs"	=> "12",
				"item_title"	=> "Job",
				"item_error_msg"=> "Please select the desired job!"
			),

			array(
				"module_id"		=> $module_data["mod_id"],
				"lang_id"		=> $_LANG_ID,
				"item_field"	=> "message",
				"item_type"		=> "usermessage",
				"item_required"	=> "1",
				"item_size_xs"	=> "12",
				"item_title"	=> "Message",
				"item_error_msg"=> "Enter your message!",

			),
		);


		//generate default form structure
		foreach ($fields as $key => $val) {

			$val["item_id"] = $this->db->QueryInsert(
				$this->tables["plugin:jobs_fields"] , 
				$val
			);

			$this->db->QueryUpdate(
				$this->tables["plugin:jobs_fields"] , 
				array(
					"item_order"	=> $val["item_id"]
				),
				"item_id ={$val[item_id]}"
			);

			$this->db->QueryInsert(
				$this->tables["plugin:jobs_fields_lang"] ,
				$val
			);
		}
		

		$this->CreatePageTitleBlock(array(
			"module_id"	=> $module_data["mod_id"],
			"title"		=> $module_data["mod_name"],
			"subtitle"	=> "You can edit this section in the Module Head tab",
			"show"		=> 1,
		));

		$widgets = array("__CONTENT__");

		if (is_object($this->plugins["comments"])) {
			$widgets[] = $this->plugins["comments"]->GetCommentsWidget();
		}
		


		$layout = $this->plugins["layouts"]->SaveLayout(
			array(
				"name"			=> $module_data["mod_name"] . " - Details",
				"block"			=> array(
					"col"	=> array(
						0 => array(
							"size"	=> 6 , 
							"widget"	=> $widgets
						),					
						1 => array(
							"size"	=> 1 , 
							"widget"	=> array()
						),					
						2 => array(
							"size"	=> 5 , 
							"widget"	=> array( 
								$this->plugins["widgets"]->AddWidget(array(
										"type"			=> "cjobswidgetdedicatedapplyform",
										"type_name"		=> "Dedicated Apply Form",
										"title"			=> "Apply Form",
										"note"			=> "Auto-Generated",
										"settings"		=> array( "set_form_style"	=> "" , "set_button_size" => "btn-small" , "set_button_style" => ""),
										"module"		=> $module_data["mod_id"],
								))
							),
						)
					)
				)				
			)
		);

		//update the layout id
		$this->plugins["modules"]->UpdateModuleSettings(
			$module_data["mod_id"] , 
			array(
				"set_layout_details"=> $layout,
			)
		);


		$this->plugins["modules"]->CreateLangRecord(
			$this->tables["plugin:jobs_cats"],
			$this->tables["plugin:jobs_cats_lang"],
			"cat_id",
			"cat_order",
			array(
				"module_id"		=> $module_data["mod_id"],
				"cat_title"		=> "Default Category",
				"cat_url"		=> "default-category",
				"cat_status"	=> "1",
				"cat_date"		=> time()
			)
		);

	}

	function onDelete($module_data) {

		$tables  = array(
			"plugin:jobs_items" , 
			"plugin:jobs_items_lang",
			"plugin:jobs_fields",
			"plugin:jobs_fields_lang",
			"plugin:jobs_resumes",
		);

		foreach ($tables as $key => $val) {
			$this->db->Query(
				"DELETE FROM " . $this->tables[$val] . " WHERE module_id={$module_data[mod_id]}"
			);
		}

		parent::onDelete($module_data);	
	}

	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function DashboardWidgets($mod_id = null) {
		global $base , $_CONF;

		$module = $this->module->plugins["modules"]->getModuleInfo($mod_id);		

		if (!$base->acl->checkModRule($module , "msg.list")) {
			return "";
		}


		if (!$module["mod_status"]) {
			return "";
		}
	

		if (is_array($module)) {
			$_GET["module_name"] = $module["mod_name"] ;
			$_GET["module_id"] = $mod_id;
			$_CONF["forms"]["adminpath"] = _MODPATH . "jobs/forms/";

			$latest = new CSQLAdmin("dashboard/latest", $this->__parent_templates,$this->db,$this->tables,$extra);
			$content = $latest->DoEvents();
			if (!(stristr($content , "No available records.") && !$_GET["showempty"])) {

				return array(
					array(
						"width"	=> "6",
						"type"	=> "widget",
						"pos"	=> "1",
						"body"	=> $content
					),
				);
			}
		}
		

	}


	function DashboardNumbers($module) {
		global $_SESS , $base;

		$module = $this->module->plugins["modules"]->GetModuleInfo($module);

		if (!$base->acl->checkModRule($module , "msg.list")) {
			return "";
		}


		if (!$module["mod_status"]) {
			return "";
		}
	

		if (is_array($module)) {

			return array(
				array(
					"skin"		=> "Purple",
					"icon"		=> "stack2",
					"link"		=> "index.php?mod=jobs&module_id={$module[mod_id]}&sub=resumes",
					"count"		=> $this->db->RowCount($this->tables['plugin:jobs_resumes'], "WHERE module_id={$module[mod_id]} AND item_new=1 AND item_date > " . $this->plugins["dashboard"]->GetAccessDate($module["mod_id"])),
					"title"		=> "New Applicants",
					"subtitle"	=> $module["mod_name"],
				),
			);

		}
	}




	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function MessagesDelete() {

		if (is_array($_POST["item_id"])) {
			$this->db->Query(
				"DELETE FROM {$this->tables['plugin:maintenance_messages']} WHERE item_id IN (" . implode("," , $_POST["item_id"]). ")"
			);

			//remove files if exists
			foreach ($_POST["item_id"] as $key => $val) {
				Cfile::Remove("../upload/jobs/files/" . $val . ".file");
			}		
		}
		
		die("1");
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function PrepareMSGFields(&$forms , $sub) {
		if (($_GET["action"] == "edit") || ($_GET["action"] == "store")) {

			$message = $this->db->QFetchArray("SELECT * FROM {$this->tables['plugin:jobs_resumes']} WHERE item_id={$_REQUEST[item_id]}");

			if ($message["item_replied"]) {

				$forms["edit"]["fields"]["box"]["1"] = $forms["edit"]["fields"]["box"]["2"];
				unset($forms["edit"]["fields"]["box"]["2"]);
			} else {

				unset($forms["edit"]["fields"]["box"]["2"]);
			}
		}		
	}




	function SendMail() {

		$message = $this->db->QFetchArray("SELECT * FROM {$this->tables['plugin:jobs_resumes']} WHERE item_id={$_POST[item_id]}");


		$vars = unserialize($message["item_vars"]);
		$vars["reply_message"] = $_POST["reply_body"];

		$this->module->plugins["mail"]->SendMail(
			$this->module->plugins["mail"]->GetMail(
				$this->tpl_module["settings"]["set_mail_reply"],
				$vars
			)
		);

		$this->db->QueryUpdate(
			$this->tables['plugin:jobs_resumes'],
			array(
				"item_replied"	=> "1",
				"item_replied_date"	=> time(),
				"item_reply"		=> $_POST["reply_body"],
			),
			"item_id={$message[item_id]}"
		);


		urlredirect("index.php?mod=jobs&sub=landing&module_id={$_GET[module_id]}");

	}



	
	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function mailTemplateVars($module , $operation = "list" , $template = "") {

		switch ($operation) {
			case "list":
				//return the list of possible templates for this 
				return array(
					"generic"	=> "Notification",
					"reply"		=> "CMS Reply",
				);
			break;

			case "vars":
				return $this->MailTemplateVarsList($template , $module);
			break;
		}		
	}


	/**
	* description
	*
	* @param
	*
	* @return
	*
	* @access
	*/
	function mailTemplateVarsList($template , $module) {
		//get all custom fields
		$fields = $this->db->QFetchRowArray(
			"SELECT * FROM 
				{$this->tables['core:languages']} as l,
				{$this->tables['plugin:jobs_fields']} as f,
				{$this->tables['plugin:jobs_fields_lang']} as fl
			WHERE 
				f.module_id={$module[mod_id]} AND
				f.item_id = fl.item_id AND 
				fl.lang_id = l.lang_id AND 
				l.lang_default = 1
			ORDER BY 
				item_order ASC"
		);


		$set = array(
			"set"	=> "Resume Variables",
			"fields"	=> array(),
		);
		if (is_array($fields)) {
			foreach ($fields as $key => $val) {
				if (($val["item_type"] != "subtitle") && ($val["item_type"] != "userjobs")) {
					$set["fields"][$val["item_field"]] = $val["item_title"];
				}				
			}			

			$set["fields"]["link"] = "CMS Details Page";
		}
		
		$sets[] = $set;

		$sets[] = array(
			"set"	=> "Position Fields",
			"fields"	=> array(
				"item_title"		=> "Title",
				"item_location"		=> "Location",
				"item_brief"		=> "Brief",
				"item_details"		=> "Details",
				"item_contact"		=> "Contact Person",
				"item_fax"			=> "Fax",
				"item_phone"		=> "Phone",
				"item_email"		=> "Email",
			)
		);

		if ($template == "reply") {
			$sets[] = array(
				"set"	=> "CMS Reply",
				"fields"	=> array(
					"reply_message"		=> "Reply text from CMS"
				)
			);
		}
		

		return $sets;

		//debug($fields);


	}

}

?>